package com.projecttunguyen.tnacl

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.selection.toggleable
import androidx.compose.foundation.selection.triStateToggleable
import androidx.compose.material3.Checkbox
import androidx.compose.material3.Text
import androidx.compose.material3.TextField
import androidx.compose.material3.TextFieldDefaults
import androidx.compose.material3.TriStateCheckbox
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.saveable.rememberSaveable
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.semantics.Role
import androidx.compose.ui.state.ToggleableState
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContent {
            Column {
                val (state, onStateChange) = remember { mutableStateOf(false) }
                val (state2, onStateChange2) = remember { mutableStateOf(false) }
                val (state3, onStateChange3) = remember { mutableStateOf(false) }
                val (state4, onStateChange4) = remember { mutableStateOf(false) }
                val (state5, onStateChange5) = remember { mutableStateOf(false) }
                val parentState =
                    remember(state, state2, state3, state4, state5) {
                        if (state && state2 && state3 && state4 && state5) ToggleableState.On
                        else if (!state && !state2 && !state3 && !state4 && !state5) ToggleableState.Off else ToggleableState.Indeterminate
                    }
                val onParentClick = {
                    val s = parentState != ToggleableState.On
                    onStateChange(s)
                    onStateChange2(s)
                    onStateChange3(s)
                    onStateChange4(s)
                    onStateChange5(s)
                }
                Column(Modifier.padding(90.dp, 60.dp, 0.dp, 10.dp)) {
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        modifier =
                        Modifier.triStateToggleable(
                            state = parentState,
                            onClick = onParentClick,
                            role = Role.Checkbox
                        )
                    ) {
                        TriStateCheckbox(
                            state = parentState,
                            onClick = null,
                        )
                        Text("All check lists complete!")
                    }
                }
                Spacer(Modifier.size(30.dp))
                Column(Modifier.padding(15.dp, 0.dp, 6.dp, 0.dp)) {
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        modifier =
                        Modifier.toggleable(
                            value = state,
                            onValueChange = onStateChange,
                            role = Role.Checkbox
                        )
                    ) {
                        Checkbox(state, null)
                        Text("1")
                        var text by rememberSaveable { mutableStateOf("") }
                        TextField(
                            value = text,
                            onValueChange = { text = it },
                            maxLines = 2,
                            textStyle = TextStyle(
                                color = Color.Black,
                                fontSize = 18.sp
                            ),
                            colors = TextFieldDefaults.colors(
                                focusedContainerColor = Color.White,
                                unfocusedContainerColor = Color.White,
                            )
                        )
                    }
                    Spacer(Modifier.size(30.dp))
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        modifier =
                        Modifier.toggleable(
                            value = state2,
                            onValueChange = onStateChange2,
                            role = Role.Checkbox
                        )
                    ) {
                        Checkbox(state2, null)
                        Text("2")
                        var text by rememberSaveable { mutableStateOf("") }
                        TextField(
                            value = text,
                            onValueChange = { text = it },
                            maxLines = 2,
                            textStyle = TextStyle(
                                color = Color.Black,
                                fontSize = 18.sp
                            ),
                            colors = TextFieldDefaults.colors(
                                focusedContainerColor = Color.White,
                                unfocusedContainerColor = Color.White,
                            )
                        )
                    }
                    Spacer(Modifier.size(30.dp))
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        modifier =
                        Modifier.toggleable(
                            value = state3,
                            onValueChange = onStateChange3,
                            role = Role.Checkbox
                        )
                    ) {
                        Checkbox(state3, null)
                        Text("3")
                        var text by rememberSaveable { mutableStateOf("") }
                        TextField(
                            value = text,
                            onValueChange = { text = it },
                            maxLines = 2,
                            textStyle = TextStyle(
                                color = Color.Black,
                                fontSize = 18.sp
                            ),
                            colors = TextFieldDefaults.colors(
                                focusedContainerColor = Color.White,
                                unfocusedContainerColor = Color.White,
                            )
                        )
                    }
                    Spacer(Modifier.size(30.dp))
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        modifier =
                        Modifier.toggleable(
                            value = state4,
                            onValueChange = onStateChange4,
                            role = Role.Checkbox
                        )
                    ) {
                        Checkbox(state4, null)
                        Text("4")
                        var text by rememberSaveable { mutableStateOf("") }
                        TextField(
                            value = text,
                            onValueChange = { text = it },
                            maxLines = 2,
                            textStyle = TextStyle(
                                color = Color.Black,
                                fontSize = 18.sp
                            ),
                            colors = TextFieldDefaults.colors(
                                focusedContainerColor = Color.White,
                                unfocusedContainerColor = Color.White,
                            )
                        )
                    }
                    Spacer(Modifier.size(30.dp))
                    Row(
                        verticalAlignment = Alignment.CenterVertically,
                        modifier =
                        Modifier.toggleable(
                            value = state5,
                            onValueChange = onStateChange5,
                            role = Role.Checkbox
                        )
                    ) {
                        Checkbox(state5, null)
                        Text("5")
                        var text by rememberSaveable { mutableStateOf("") }
                        TextField(
                            value = text,
                            onValueChange = { text = it },
                            maxLines = 2,
                            textStyle = TextStyle(
                                color = Color.Black,
                                fontSize = 18.sp
                            ),
                            colors = TextFieldDefaults.colors(
                                focusedContainerColor = Color.White,
                                unfocusedContainerColor = Color.White,
                            )
                        )
                    }
                }
            }
        }
    }
}